## FreeAnchor

The code is based on the [maskrcnn-benchmark](https://github.com/facebookresearch/maskrcnn-benchmark).

## Installation 
Check [INSTALL.md](INSTALL.md) for installation instructions.

## Reproduction on MS-COCO Dataset
You will need to download the COCO dataset and configure your own paths to the datasets.

For that, all you need to do is to modify `maskrcnn_benchmark/config/paths_catalog.py` to point to the location where your dataset is stored.

### Configuration Files
We provide 4 configuration files in the "configs" directory.

| Backbone | Iter. | Setting | Config File |  
| :-----: | :---: | :---: | :----------: |
| ResNet-50-FPN    |   90k |   std.  | configs/free_anchor_R-50-FPN_1x.yaml      | 
| ResNet-101-FPN   |   90k |   std.  | configs/free_anchor_R-101-FPN_1x.yaml     | 
| ResNet-101-FPN   |  135k |   std.  | configs/free_anchor_R-101-FPN_1.5x.yaml   | 
| ResNeXt-101-FPN  |  135k |   dev.  | configs/free_anchor_X-101-FPN_j1.5x.yaml  | 


### Multi-GPU Training
You can use 4 Tesla V100 GPUs (32GB memory) or 8 GPUs (>10GB memory) for training. 
```bash
cd path_to_free_anchor
export NGPUS=4  # (or 8)
python -m torch.distributed.launch --nproc_per_node=$NGPUS tools/train_net.py --config-file "path/to/config/file.yaml"
```

### Test on MS-COCO test-dev

```bash
cd path_to_free_anchor
export NGPUS=4  # (or 8)
python -m torch.distributed.launch --nproc_per_node=$NGPUS tools/test_net.py --config-file "path/to/config/file.yaml" MODEL.WEIGHT "path/to/.pth file" DATASETS.TEST "('coco_test-dev',)"
```

### Evaluate NMS Recall

```bash
cd path_to_free_anchor
export NGPUS=4  # (or 8)
python  -m torch.distributed.launch --nproc_per_node=$NGPUS tools/eval_NR.py --config-file "path/to/config/file.yaml" MODEL.WEIGHT "path/to/.pth file"
```
